/**  @file bta_motion_detector.c
*  
*    @brief This file implements the motion detector filter
*  
*    BLT_DISCLAIMER
*  
*    @author Alex Falkensteiner
*  
*    @cond svn
*  
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*  
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bvq_queue.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_MOTION_DETECTOR_H_INCLUDED
#define BTA_MOTION_DETECTOR_H_INCLUDED


typedef struct BTA_FltMotionDetectorInst {
    uint16_t slafWindowLength;
    uint8_t slafStride;
    uint8_t slafStrideCounter;
    uint16_t threshold;
    BVQ_QueueInst *channelQueueInst;
    BTA_Channel *sum;
    BTA_Channel *avg;
    BTA_InfoEventInst *infoEventInst;
} BTA_FltMotionDetectorInst;


BTA_Status BFLTmotionDetectorInit(BTA_FltMotionDetectorConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTmotionDetectorClose(BTA_FltHandle *handle);
BTA_Status BFLTmotionDetectorApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif
